;/***********************************************/
;/*		}N` 			*/
;/***********************************************/

VRAMSET	MACRO	FONT_ADDR,BG_ADDR
	LD	HL,FONT_ADDR
	LD	DE,BG_ADDR
	CALL	VRAMSET
	ENDM



BGCHK	MACRO	OPE1,OPE2
	PUSH	BC
	PUSH	DE
	PUSH	HL
	LDM	B,OPE1
	LD	A,OPE2
	CALL	BGCHK
	POP	HL
	POP	DE
	POP	BC
	ENDM



BGCHK2	MACRO	OPE1,OPE2
	PUSH	BC
	PUSH	DE
	PUSH	HL
	LDM	B,OPE1
	LD	A,OPE2
	CALL	BGCHK2
	POP	HL
	POP	DE
	POP	BC
	ENDM



BGPUT1	MACRO	OPE1,OPE2,OPE3		; 8 * 8 DOT obNOEh \
	PUSHALL
	LD	A,OPE1
	LD	B,A
	LD	A,OPE3
	LD	C,A
	LD	A,OPE2
	CALL	BGPUT1
	POPALL
	ENDM



BGPUT2	MACRO	OPE1,OPE2,OPE3		; 16 * 16 DOT obNOEh \
	PUSHALL
	LD	A,OPE1
	LD	B,A
	LD	A,OPE3
	LD	C,A
	LD	A,OPE2
	CALL	BGPUT2
	POPALL
	ENDM



MEM_PUT	MACRO	OPE1,OPE2,OPE3,OPE4	; |e(OPE3) \
	PUSHALL
	LD	HL,OPE3
	LDM	(WK0),OPE1
	LDM	(WK1),OPE2
	LD	B,OPE4
	CALL	HEX_PUT
	POPALL
	ENDM



HEX_PUT	MACRO	OPE1,OPE2,OPE3		; |e(HL) \
	PUSHALL
	LDM	(WK0),OPE1
	LDM	(WK1),OPE2
	LD	B,OPE3
	CALL	HEX_PUT
	POPALL
	ENDM



STR_PUT	MACRO	OPE1,OPE2,OPE3		; (OPE3) \
	PUSHALL
	LDM	(WK0),OPE1
	LD	(WK3),A
	LDM	(WK1),OPE2
	LD	HL,OPE3
	CALL	STR_PUT
	POPALL
	ENDM



;/**********************************************/
;/*      	Tu[`                   */
;/**********************************************/

;/************* KAN_PUT ************************/

KAN_PUT
	CALL	LCDC_OFF
	RAMFILL	$8800,$97FF,$00
	LD	HL,$8800	; FONT SET
	LD	DE,VVRAM
	LD	C,11

KAN_PUT20
	LD	B,20

KAN_PUT10
	PUSH	BC
	PUSH	DE
	PUSH	HL
	LDM	H,(DE)
	INC	DE
	LDM	L,(DE)
	LD	A,H
	CP	$20
	JP	Z,KAN_PUT90
	CP	$81
	JR	C,KAN_PUT50
	CP	$E0
	JR	C,KAN_PUT70
	CP	$E2
	JR	C,KAN_PUT99
	LD	DE,-$BD
	ADD	HL,DE

KAN_PUT99
	LD	DE,-$4043
	ADD	HL,DE

KAN_PUT70
	LD	DE,-$8140
	ADD	HL,DE		; HL = (DE) - $8140
	LD	A,H
	SRL	A
	INC	A
	INC	A
	LD	($2000),A	; BANK = H/2 +2
	LD	A,H
	AND	%00000001
	LD	H,A
	SLA	L
	RL	H
	SLA	L
	RL	H
	SLA	L
	RL	H
	SLA	L
	RL	H
	SLA	L
	RL	H
	LD	BC,$4000
	ADD	HL,BC
	PUSH	HL
	POP	DE		; DE = (HL MOD $200) * 32 +4000H
	POP	HL		; HL = VRAM ADDR
	PUSH	HL
	CALL	KAN_PUT00
	CALL	KAN_PUT00
	LD	BC,18*16
	ADD	HL,BC
	CALL	KAN_PUT00
	CALL	KAN_PUT00
	POP	HL
	POP	DE
	POP	BC
	INC	DE
	INC	DE
	ADD16	H,L,32
	DEC	B
	JP	Z,KAN_PUT60
	DEC	B
	JP	Z,KAN_PUT60
	JP	KAN_PUT10

KAN_PUT50
	LD	H,0
	LD	L,A
	SLA	L
	RL	H
	SLA	L
	RL	H
	SLA	L
	RL	H
	SLA	L
	RL	H
	LD	BC,CHR_DAT+$800
	ADD	HL,BC
	POP	DE
	PUSH	DE
	LD	BC,16
	LDM	($2000),1	; BANK = 1
	CALL	DATA_MOV

KAN_PUT90
	POP	HL
	POP	DE
	POP	BC
	INC	DE
	ADD16	H,L,16
	DEC	B
	JP	NZ,KAN_PUT10

KAN_PUT60
	ADD16	D,E,12
	DEC	C
	JP	NZ,KAN_PUT20

	LD	HL,$9800	; BG VRAM ($9800 - $9BFF) SET
	LD	DE,12
	LD	A,$80
	LD	C,18

KAN_PUT30
	LD	B,20

KAN_PUT40
	LD	(HLI),A
	INC	A
	CP	$80
	JR	NZ,KAN_PUT80
	LD	A,$7F

KAN_PUT80
	DEC	B
	JR	NZ,KAN_PUT40
	ADD	HL,DE
	DEC	C
	JR	NZ,KAN_PUT30

	LDM	(LCDC),$81	; BG ON,OBJ OFF,8*8,WINDOW OFF
	LDM	($2000),1
	RET



KAN_PUT00
	LDM	(HLI),(DE)
	LDM	(HLI),(DE)
	INC	DE
	LDM	(HLI),(DE)
	LDM	(HLI),(DE)
	INC	DE
	LDM	(HLI),(DE)
	LDM	(HLI),(DE)
	INC	DE
	LDM	(HLI),(DE)
	LDM	(HLI),(DE)
	INC	DE
	LDM	(HLI),(DE)
	LDM	(HLI),(DE)
	INC	DE
	LDM	(HLI),(DE)
	LDM	(HLI),(DE)
	INC	DE
	LDM	(HLI),(DE)
	LDM	(HLI),(DE)
	INC	DE
	LDM	(HLI),(DE)
	LDM	(HLI),(DE)
	INC	DE
	RET



;/************* VRAMSET ************************/

VRAMSET
	DI
	CALL	LCDC_OFF	; kbcb Xgbv
	PUSH	DE
	PUSH	DE

	LD	DE,$8000	; LN^ q`l ($8000 - $97FF)
	LD	BC,$1800	; 
	CALL	DATA_MOV	; LN^ ]

	POP	HL		;
	LD	DE,$9800	; XN[q`l($9800 - $9A3F)
	LD	BC,$0400	; 
	CALL	DATA_MOV3	; XN[f[^]

	POP	HL		;
	LD	DE,$9C00	; XN[q`l($9C00 - $9E3F)
	LD	BC,$0400	; 
	CALL	DATA_MOV3	; XN[f[^]

	LDM	(BGP),$E4	; pbg f[^ Zbg
	LDM	(OBP0),$E4	;
	LDM	(OBP1),$9C	;

	LDM	(LCDC),$83	; kbcb I
	EI
	RET



;/************* BGCHK **************************/

BGCHK
	AND	%11111000
	LD	D,0

	SLA	A
	RL	D
	SLA	A
	RL	D

	SRL	B
	SRL	B
	SRL	B

	ADD	A,B
	LD	E,A
	LD	HL,VVRAM
	ADD	HL,DE
	LD	A,(HL)
	CP	$C0
	RET



;/************* BGCHK2 *************************/

BGCHK2	LD	D,A
	XOR	A
	SRL	D
	RR	A
	SRL	D
	RR	A
	SRL	D
	RR	A
	ADD	A,B
	LD	E,A
	LD	HL,VVRAM
	ADD	HL,DE
	LD	A,(HL)
	CP	$C0
	RET



;/************* BGPUT1 *************************/

BGPUT1
	LD	D,A
	XOR	A
	SRL	D
	RR	A
	SRL	D
	RR	A
	SRL	D
	RR	A
	ADD	A,B
	LD	E,A
	LD	HL,VVRAM
	ADD	HL,DE
	LDM	(HL),C
	RET



;/************* BGPUT2 *************************/

BGPUT2
	LD	D,A
	XOR	A
	SRL	D
	RR	A
	SRL	D
	RR	A
	SRL	D
	RR	A
	ADD	A,B
	LD	E,A
	LD	HL,VVRAM
	ADD	HL,DE
	LD	A,C

	LD	(HLI),A
	INC	A
	LD	(HL),A

	ADD	A,15
	LD	BC,63
	ADD	HL,BC

	LD	(HLI),A
	INC	A
	LD	(HL),A

	RET



;/************* HEX_PUT **************************/

HEX_PUT
	LD	A,(HL)
	SRL	A
	SRL	A
	SRL	A
	SRL	A
	LD	(WK2),A
	BGPUT1	(WK0),(WK1),(WK2)
	ADDM	(WK0),(WK0),1

	LD	A,(HLI)
	AND	$0F
	LD	(WK2),A
	BGPUT1	(WK0),(WK1),(WK2)
	ADDM	(WK0),(WK0),-1
	ADDM	(WK1),(WK1),1

	DEC	B
	JR	NZ,HEX_PUT
	RET



;/************* STR_PUT **************************/

STR_PUT
	LD	A,(HLI)
	CP	'@'
	JP	Z,SYURYOU
	CP	'/'
	JP	Z,KAIGYOU
	LD	(WK2),A
	BGPUT1	(WK0),(WK1),(WK2)
	ADDM	(WK0),(WK0),1
	JP	STR_PUT

SYURYOU
	RET

KAIGYOU
	LDM	(WK0),(WK3)
	ADDM	(WK1),(WK1),1
	JP	STR_PUT



;/************* VV_RAMC *************************/

VV_RAMC
	LD	HL,VVRAM	; z V-RAM CLS
	LD	BC,$0C00
VV_RAMC00
	LD	A,$20
	LD	(HLI),A
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,VV_RAMC00
	RET



;/************* WIN_PUT ************************/

WIN_PUT
	LD	A,(WRITE_C)	; BG ݃JE^ 4̔{Ȃ牽Ȃ
	AND	3
	RET	Z

	LD	C,0
	LD	DE,$9C00
	LD	B,%10001011
	LD	A,(WRITE_F)	; ʐ؂芷ptO 1 Ȃ $9C00 WRITE
	DEC	A
	JR	Z,WRITE_F01
	LD	DE,$9800
	LD	B,%10000011
WRITE_F01

	DECM	(WRITE_C)
	JR	Z,WRITE_C01	; BG ݃JE^ 1 ̎
	DEC	A
	JR	Z,WRITE_C02	; BG ݃JE^ 2 ̎

WRITE_C03
	LD	HL,VVRAM
	LD	B,8
	CALL	BLOCK_COPY
	RET

WRITE_C02
	LD	HL,VVRAM+$100
	INC	D
	LD	B,8
	CALL	BLOCK_COPY
	RET

WRITE_C01
	LDM	(LCDC),B	; ʐ؂芷
	LD	A,(WRITE_F)	; ʐ؂芷ptO𔽓]
	XOR	1
	LD	(WRITE_F),A
	LD	HL,VVRAM+$200
	INC	D
	INC	D
	LD	B,2
	CALL	BLOCK_COPY
	LDM	(WRITE_C),3
	RET

BLOCK_COPY			; 3VuN1ʕ\
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E
	LDM	(DE),(HLI)
	INC	E

	LD	A,L
	ADD	A,12
	LD	L,A
	LD	A,H
	ADC	A,C
	LD	H,A
	ADD2	E,12

	DEC	B
	JR	NZ,BLOCK_COPY
	RET



